
# Figure 4 - TPP #
##################


library(plyr)
library(dplyr)
library(stringr)
library(useful)
library("data.table")
library("conflicted")
library(reshape2)
conflict_prefer("mutate", "dplyr")
suppressPackageStartupMessages(library("tidyverse"))
conflict_prefer("filter", "dplyr")
library(ggplot2)
library(dplyr)
library(epiDisplay)
library(gmodels)


source('D:/Pipeline comparisons/Writing/R Functions/GBS_Function.R')



PXD000923 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD000923A_pform.csv')
PXD002222 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD002222A_pform.csv')
PXD002756 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD002756A_pform.csv')
PXD004705 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD004705A_pform.csv')
PXD004939 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD004939A_pform.csv')
PXD005241 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD005241A_pform.csv')
PXD012764 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD012764A_pform.csv')
PXD019291 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD019291A_pform.csv')


PXD000923_01 <- PXD000923[1:max(which(PXD000923$FLR_Adj_Score<=0.01)),]
PXD002222_01 <- PXD002222[1:max(which(PXD002222$FLR_Adj_Score<=0.01)),]
PXD002756_01 <- PXD002756[1:max(which(PXD002756$FLR_Adj_Score<=0.01)),]
PXD004705_01 <- PXD004705[1:max(which(PXD004705$FLR_Adj_Score<=0.01)),]
PXD004939_01 <- PXD004939[1:max(which(PXD004939$FLR_Adj_Score<=0.01)),]
PXD005241_01 <- PXD005241[1:max(which(PXD005241$FLR_Adj_Score<=0.01)),]
PXD012764_01 <- PXD012764[1:max(which(PXD012764$FLR_Adj_Score<=0.01)),]
PXD019291_01 <- PXD019291[1:max(which(PXD019291$FLR_Adj_Score<=0.01)),]

PXD000923_05 <- PXD000923[1:max(which(PXD000923$FLR_Adj_Score<=0.05)),]
PXD002222_05 <- PXD002222[1:max(which(PXD002222$FLR_Adj_Score<=0.05)),]
PXD002756_05 <- PXD002756[1:max(which(PXD002756$FLR_Adj_Score<=0.05)),]
PXD004705_05 <- PXD004705[1:max(which(PXD004705$FLR_Adj_Score<=0.05)),]
PXD004939_05 <- PXD004939[1:max(which(PXD004939$FLR_Adj_Score<=0.05)),]
PXD005241_05 <- PXD005241[1:max(which(PXD005241$FLR_Adj_Score<=0.05)),]
PXD012764_05 <- PXD012764[1:max(which(PXD012764$FLR_Adj_Score<=0.05)),]
PXD019291_05 <- PXD019291[1:max(which(PXD019291$FLR_Adj_Score<=0.05)),]


AllRice_pform_Max<-dplyr::bind_rows( PXD000923,  PXD002222,  PXD002756,  PXD004705,
                                       PXD004939,  PXD005241,  PXD012764,  PXD019291)

AllRice_pform_Max_01<-dplyr::bind_rows( PXD000923_01,  PXD002222_01,  PXD002756_01,  PXD004705_01,
                                     PXD004939_01,  PXD005241_01,  PXD012764_01,  PXD019291_01)

AllRice_pform_Max_05<-dplyr::bind_rows( PXD000923_05,  PXD002222_05,  PXD002756_05,  PXD004705_05,
                                        PXD004939_05,  PXD005241_05,  PXD012764_05,  PXD019291_05)


AllRice_pform_Max$New_FLR_PEP <-AllRice_pform_Max$FLR_Adj_Score
AllRice_pform_Max_01$New_FLR_PEP <-AllRice_pform_Max_01$FLR_Adj_Score
AllRice_pform_Max_05$New_FLR_PEP <-AllRice_pform_Max_05$FLR_Adj_Score

AllRice_pform_Max_Final <- GSB_Function(AllRice_pform_Max_01,AllRice_pform_Max_05)

str(AllRice_pform_Max_Final)

AllRice_pform_Max_Final$PROTEIN_POS<-NULL
AllRice_pform_Max_Final$PRO_pos_list<-NULL
AllRice_pform_Max_Final$PTM_length<-NULL
AllRice_pform_Max_Final$PTM_beg2<-NULL
AllRice_pform_Max_Final$PTM_end2<-NULL
AllRice_pform_Max_Final$PTM_End<-NULL
AllRice_pform_Max_Final$PTM_Beginning<-NULL

RiceY <- AllRice_pform_Max_Final[(AllRice_pform_Max_Final$Amino=="Y") & (AllRice_pform_Max_Final$cat != "Bronze"),]


CrossTable(AllRice_pform_Max_Final$cat, AllRice_pform_Max_Final$Amino)

df2 <- data.frame(Amino=rep(c("S", "T", "Y", "A"), each=3),
                  Level=rep(c("Gold:2898", "Silver:4200", "Bronze:7602"),4),
                  Unique_sites=c(2644, 3730, 6400, 244, 404, 742, 7, 19, 78, 3, 47, 382))
head(df2)

ggplot(data=df2, aes(x=Level, y=Unique_sites, fill=Amino)) +
  geom_bar(stat="identity")

p <- df2 %>%
  dplyr::arrange(Unique_sites) %>%
  mutate(Level = factor(Level, levels=c("Gold:2898", "Silver:4200", "Bronze:7602"))) %>%
  ggplot(aes(x=Level, y=Unique_sites, fill=Amino)) +
  geom_bar(stat="identity") +
  xlab("") 

p + geom_text(aes(label = Unique_sites), position = position_stack(vjust = 0.8), size = 5) + 
  theme(text = element_text(size = 20))

write.csv(AllRice_pform_Max_Final, "D:/Pipeline comparisons/Writing/Data/GSB/Rice/TPP_GSB.csv", row.names=FALSE)